import Url from 'lib/Url';
import AuthStore from 'stores/Auth';
import PermissionStore from 'stores/Permissions';

function isCompleteOrganization() {
    return !AuthStore.isIncompleteOrganization();
}

function getFirstDomain() {
    return AuthStore.getOrganization().getIn(['domains', 'all', 0]);
}

export default [{
    id: 'service.metrika',
    metrika: 'Метрика',
    available: true,
}, {
    id: 'service.webmaster',
    metrika: 'Вебмастер',
    available: true,
}, {
    id: 'service.direct',
    metrika: 'Директ',
    available: true,
}, {
    id: 'service.mail',
    metrika: 'Почта',
    available: isCompleteOrganization,
    canBeEnabled: true,
}, {
    id: 'service.yamb',
    metrika: 'Чаты',
    available: isCompleteOrganization,
    canBeEnabled: true,
}, {
    id: 'service.disk',
    metrika: 'Диск',
    available: isCompleteOrganization,
    canBeEnabled: true,
}, {
    id: 'service.staff',
    metrika: 'Люди и команды',
    available: () => isCompleteOrganization(),
    canBeEnabled: true,
}, {
    id: 'service.tracker',
    metrika: 'Трекер',
    available: isCompleteOrganization,
    canBeEnabled: true,
}, {
    id: 'service.wiki',
    metrika: 'Вики',
    available: isCompleteOrganization,
    canBeEnabled: true,
}, {
    id: 'service.forms',
    metrika: 'Формы',
    available: isCompleteOrganization,
    canBeEnabled: true,
}, {
    id: 'service.calendar',
    metrika: 'Календарь',
    available: isCompleteOrganization,
    canBeEnabled: true,
}, {
    id: 'service.yandexsprav',
    metrika: 'Справочник',
    available: true,
}, {
    id: 'service.portal',
    url: () => isCompleteOrganization() ?
        Url.getPath('admin') :
        Url.getPath('admin', 'domains', getFirstDomain()),
    metrika: 'Администрирование',
    settingsLink: Url.getPath('admin'),
    available: () => PermissionStore.allowsOrganizationStructureEditing() || AuthStore.isAdmin(),
    actionLink: () => Url.getPath(`admin#${AuthStore.getOrganization().hasOwnedDomains() ? 'add-user' : 'invite-user'}`),
}];
