import PropTypes from 'prop-types';
import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import Avatar from 'ui-components/lib/Avatar';
import DepartmentStore from 'stores/Departments';
import ApplicationStore from 'stores/Application';
import Close from 'components/Group/Controls/CloseSubsection';

import './card-header.css';

const CardHeader = React.createClass({

    mixins: [PureRenderMixin],

    render() {
        const { id } = this.props;
        const department = DepartmentStore.get(id);
        let closeButton;

        if (!department) {
            return null;
        }

        if (ApplicationStore.getPrimaryType() === 'groups') {
            closeButton = <Close />;
        }

        return (
            <div className="department-header section-header card-header">
                {closeButton}
                <div className="section-header__avatar">
                    <Avatar url={department.getAvatar()} size="xxl" />
                </div>
                <h2 className="section-header__title">
                    {department.getName()}
                </h2>
            </div>
        );
    },
});

CardHeader.propTypes = {
    id: PropTypes.string,
};

export default CardHeader;
