import PropTypes from 'prop-types';
import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import StoreMixin from 'lib/StoreMixin';

import DepartmentStore from 'stores/Departments';
import PermissionStore from 'stores/Permissions';
import UserStore from 'stores/Users';
import UIStore from 'stores/UI';

import Header from './Header';
import UpdateHeader from './UpdateHeader';
import MoveHeader from './MoveHeader';

import './index.css';

const EditableHeader = React.createClass({

    mixins: [StoreMixin, PureRenderMixin],

    getStoreState() {
        return {
            edit: UIStore.getEditedDepartment(this.props.id),
        };
    },

    componentDidMount() {
        this.subscribe([
            DepartmentStore,
            PermissionStore,
            UserStore,
            UIStore,
        ]);
    },

    render() {
        const { id } = this.props;
        const { edit } = this.state;

        const className = [
            'department-header__container',
            edit ? `department-header__container_${edit.mode}` : null,
        ].filter(Boolean).join(' ');

        return (
            <div className={className} key={edit ? edit.mode : null}>
                <Header id={id} />
                <UpdateHeader id={id} />
                <MoveHeader id={id} />
            </div>
        );
    },

});

EditableHeader.propTypes = {
    id: PropTypes.string,
};

export default EditableHeader;
