import PropTypes from 'prop-types';
import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import ApplicationStore from 'stores/Application';
import DepartmentStore from 'stores/Departments';
import PermissionStore from 'stores/Permissions';
import AuthStore from 'stores/Auth';

import { i18n } from 'lib/i18n';
import Add from './Controls/Add';

const Footer = React.createClass({

    mixins: [PureRenderMixin],

    render() {
        const { id } = this.props;
        const department = DepartmentStore.get(id);

        const editable = PermissionStore.allowsAddingToDepartment(department) &&
            ApplicationStore.getPrimaryType() !== 'groups' && AuthStore.getViewMode() === 'admin' &&
            !department.isOutstaff();

        if (!department || !editable) {
            return null;
        }

        return (
            <div className="department-footer section-footer">
                <Add
                    id={id}
                    title={i18n('department.action_description.add', {
                        department_name: department.getName(),
                    })}
                />
            </div>
        );
    },
});

Footer.propTypes = {
    id: PropTypes.string,
};

export default Footer;
