import PropTypes from 'prop-types';
import React from 'react';
import Form from 'ui/Form';
import Textarea from 'ui/Textarea';
import { i18n } from 'lib/i18n';

const Description = React.createClass({
    render() {
        const { department, locale, errors } = this.props;

        return (
            <Form.Item label={i18n('department.description')} errors={errors.description}>
                <Textarea
                    id="department-form-description"
                    name={`description[${locale}]`}
                    size="m"
                    val={department ? department.getDescription(locale) : ''}
                    width="available"
                />
            </Form.Item>
        );
    },
});

Description.propTypes = {
    department: PropTypes.object,
    locale: PropTypes.string,
    errors: PropTypes.object,
};

Description.defaultProps = {
    locale: 'ru',
    errors: {},
};

export default Description;
