import PropTypes from 'prop-types';
import React from 'react';
import { i18n } from 'lib/i18n';
import Form from 'ui/Form';
import Input from 'ui/Input';
import AuthStore from 'stores/Auth';

const Email = React.createClass({
    render() {
        const { department, clearable, errors } = this.props;

        return (
            <Form.Item
                label={i18n('department.department_email')}
                errors={errors.label}
            >
                <Input
                    id="department-form-label"
                    hasClear={clearable}
                    name="label"
                    size="m"
                    val={department ? department.get('label') : ''}
                    suffix={`@${AuthStore.getOrganizationDomain()}`}
                    width="available"
                />
            </Form.Item>
        );
    },
});

Email.propTypes = {
    department: PropTypes.object,
    clearable: PropTypes.bool,
    errors: PropTypes.object,
};

Email.defaultProps = {
    clearable: true,
    errors: {},
};

export default Email;
