import PropTypes from 'prop-types';
import React from 'react';
import { i18n } from 'lib/i18n';
import Form from 'ui/Form';
import SuggestPicker from 'components/SuggestPicker';

const Head = React.createClass({

    getInitialState() {
        const { department } = this.props;
        const head = department ? department.getHead() : null;

        return { head };
    },

    _handlePickerChange(items) {
        // только один руководитель
        this.setState({ head: items[0] || null });
    },

    render() {
        const { head } = this.state;
        const { errors } = this.props;

        return (
            <Form.Item label={i18n('department.head')} errors={errors.head}>
                <input
                    type="hidden"
                    name="head_id"
                    value={head ? head.getId() : ''}
                />
                <SuggestPicker
                    id="department-form-head"
                    suggest
                    multiple={false}
                    onChange={this._handlePickerChange}
                    type="user"
                    value={head ? [head] : []}
                    width="available"
                />
            </Form.Item>
        );
    },

});

Head.propTypes = {
    department: PropTypes.object,
    errors: PropTypes.object,
};

Head.defaultProps = {
    errors: {},
};

export default Head;
