import PropTypes from 'prop-types';
import React from 'react';
import { i18n } from 'lib/i18n';
import Form from 'ui/Form';
import Input from 'ui/Input';

const Name = React.createClass({
    render() {
        const { department, clearable, locale, errors } = this.props;

        return (
            <Form.Item label={i18n('department.name')} errors={errors.name} required>
                <Input
                    id="department-form-name"
                    hasClear={clearable}
                    name={`name[${locale}]`}
                    size="m"
                    val={department ? department.getName(locale) : ''}
                    width="available"
                />
            </Form.Item>
        );
    },
});

Name.propTypes = {
    department: PropTypes.object,
    clearable: PropTypes.bool,
    locale: PropTypes.string,
    errors: PropTypes.object,
};

Name.defaultProps = {
    clearable: true,
    locale: 'ru',
    errors: {},
};

export default Name;
