import PropTypes from 'prop-types';
import React from 'react';
import { i18n } from 'lib/i18n';
import Form from 'ui/Form';
import SuggestPicker from 'components/SuggestPicker';

const Parent = React.createClass({

    getInitialState() {
        return { parent: this.props.department };
    },

    _handlePickerChange(items) {
        // только один родительский отдел
        this.setState({ parent: items[0] || null });
    },

    render() {
        const { parent } = this.state;
        const { errors } = this.props;

        return (
            <Form.Item label={i18n('department.parent')} errors={errors.parent}>
                <input
                    type="hidden"
                    name="parent_id"
                    value={parent ? parent.getId() : ''}
                />
                <SuggestPicker
                    id="department-form-parent"
                    suggest
                    multiple={false}
                    onChange={this._handlePickerChange}
                    type="department"
                    value={parent ? [parent] : []}
                    width="available"
                />
            </Form.Item>
        );
    },

});

Parent.propTypes = {
    department: PropTypes.object,
    errors: PropTypes.object,
};

Parent.defaultProps = {
    errors: {},
};

export default Parent;
