import PropTypes from 'prop-types';
import React from 'react';
import Button from 'react-bem-components/lib/Button';
import Form from 'ui/Form';
import FormMixin from 'lib/FormMixin';

import DepartmentActions from 'actions/Department';
import DepartmentStore from 'stores/Departments';
import AuthStore from 'stores/Auth';
import departmentValidator from 'validation/department';
import { i18n } from 'lib/i18n';
import Metrika from 'lib/metrika';
import filterInput from './filterInput';
import Email from './Components/Email';
import Head from './Components/Head';
import Description from './Components/Description';
import Name from './Components/Name';

const Update = React.createClass({

    mixins: [FormMixin],

    getInitialState() {
        return { errors: departmentValidator.getErrors() };
    },

    _handleFormSubmit(data) {
        if (this._use(departmentValidator, filterInput)._validate(data)) {
            Metrika.send('Структура', 'Шапка отдела', 'Редактирование', 'Сохранить');

            return this._submit(DepartmentActions.updateDepartment(data, this.props.id), {
                success: i18n('department.status.updated'),
                failure: i18n('department.status.failed_to_update'),
            });
        }
    },

    render() {
        const { id } = this.props;
        const errors = this.state.errors.toJS();
        const department = DepartmentStore.get(id);
        const isRoot = department.isRoot();
        let fields = [];

        if (!isRoot) {
            fields.push(
                <Name
                    key="field-name"
                    department={department}
                    clearable={false}
                    errors={errors}
                />,
                <Description
                    key="field-description"
                    department={department}
                    errors={errors}
                />,
                AuthStore.hasOwnedDomains() &&
                <Email
                    key="field-email"
                    department={department}
                    errors={errors}
                />,
                <Head
                    key="field-head"
                    department={department}
                />
            );
        } else if (AuthStore.hasOwnedDomains()) {
            fields.push(
                <Email
                    key="field-email-root"
                    department={department}
                    errors={errors}
                />
            );
        }

        return (
            <Form
                className="update-department-form form"
                onSubmit={this._handleFormSubmit}
            >
                {fields}
                <Form.Error value={errors._common} mod="standalone" />

                <Form.Buttons>
                    <Button
                        text={i18n('department.action.save_changes')}
                        type="submit"
                        view="action"
                        size="l"
                        width="available"
                    />
                </Form.Buttons>

            </Form>
        );
    },

});

Update.propTypes = {
    id: PropTypes.string,
    onSubmit: PropTypes.func,
    onCancel: PropTypes.func,
};

export default Update;
