import PropTypes from 'prop-types';
import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import UIActions from 'actions/UI';
import MoveForm from './Forms/Move';

const MoveHeader = React.createClass({

    mixins: [PureRenderMixin],

    _handleEditDone() {
        UIActions.departmentEdited(this.props.id);
    },

    render() {
        const { id } = this.props;

        return (
            <div className="department-header department-header_move section-header unpadded">
                <MoveForm id={id} onSubmit={this._handleEditDone} />
                <div className="section-header__close" onClick={this._handleEditDone} />
            </div>
        );
    },

});

MoveHeader.propTypes = {
    id: PropTypes.string,
};

export default MoveHeader;
