import _ from 'lodash';
import React from 'react';
import { i18n } from 'lib/i18n';
import Metrika from 'lib/metrika';
import Select from 'lego-ui/Select';

const DomainList = React.createClass({

    getInitialState() {
        return _.pick(this.props, ['val', 'options', 'size']);
    },

    _prerenderValue(text) {
        return (
            <span
                dangerouslySetInnerHTML={{
                    __html: i18n('dns_settings.selected_domain', { domain: text }),
                }}
            />
        );
    },

    _handleChange(event) {
        Metrika.send('DNS', 'Выбор домена');

        this.setState({ val: event.target.value });

        if (this.props.onChange) {
            this.props.onChange(event.target.value);
        }
    },

    render() {
        return (
            <div className="dns__domain">
                <Select
                    {...this.state}
                    onChange={this._handleChange}
                    prerenderValue={this._prerenderValue}
                    ref={this._update}
                />
            </div>
        );
    },

});

export default DomainList;
