import React from 'react';
import { i18n } from 'lib/i18n';
import Metrika from 'lib/metrika';

import ModalActions from 'actions/Modal';
import Button from 'lego-ui/Button';
import DnsStore from 'stores/Dns';

import EditForm from 'components/Dns/Forms/Edit';

const EditSoaRecord = React.createClass({

    getInitialState() {
        return {
            recordId: DnsStore.getSoaRecordId(),
        };
    },

    _handleEditClick() {
        const { domain } = this.props;

        Metrika.send('DNS', 'Клик в редактировать SOA-запись');

        ModalActions.open({
            component: EditForm,
            props: {
                domain: domain && domain.getName(),
                recordType: 'SOA',
                recordId: this.state.recordId,
                onSubmit: this._handleFormDone,
                onCancel: this._handleFormDone,
            },
        });
    },

    _handleFormDone() {
        ModalActions.close();
    },

    render() {
        if (!this.state.recordId) {
            return null;
        }

        return (
            <div className="dns__soa-edit">
                <Button
                    text={i18n('dns_record.edit_soa_record')}
                    onClick={this._handleEditClick}
                />
            </div>
        );
    },

});

export default EditSoaRecord;
