import PropTypes from 'prop-types';
import React from 'react';

import { block } from 'bem-cn';
import Link from 'ui/Link';
import LangSwitcher from 'ui/LangSwitcher';

import UserActions from 'actions/User';

import ConfigStore from 'stores/Config';
import AuthStore from 'stores/Auth';

import { i18n } from 'lib/i18n';

import './index.css';
import Url from 'lib/Url';

const bFooter = block('footer');

const Footer = React.createClass({

    _changeLanguage(payload) {
        const { value: lang } = payload;

        UserActions.updateLanguage(lang);
    },

    render() {
        const currentDate = new Date();
        // Хак потому что для в хелпах на RU/COM поддерживаются только два языка, русский и английский),
        // турецкий язык есть только на com.tr, поэтому для турецкий пользователей отдельная ссылка на хелп
        const tld = AuthStore.getLocale() === 'tr' ? 'com.tr' : ConfigStore.get('app.tld');

        return (
            <div className={bFooter()}>
                <div className={bFooter('section')}>
                    <LangSwitcher language={AuthStore.getLocale()} onSelect={this._changeLanguage} />
                    <Link
                        to={ConfigStore.getHelpUrl('ui.help.main', { tld })}
                        metrika="Помощь"
                    >
                        {i18n('footer.help')}
                    </Link>
                    <Link to="/?noredirect=1" target="_self" metrika="О Коннекте">
                        {i18n('footer.promo')}
                    </Link>
                    {this.props.showDownloads &&
                        <Link to={Url.getPath('downloads')} target="_self" metrika="Скачать приложения">
                            {i18n('footer.downloads')}
                        </Link>}
                </div>
                <div className={bFooter('section')}>
                    <span className={bFooter('copyright')}>
                        &copy;&nbsp;
                        {`2001–${currentDate.getFullYear()}`}
                        ,&nbsp;
                        <Link to={ConfigStore.get('ui.relatedServices.yandex')}>«{i18n('footer.yandex')}»</Link>
                    </span>
                </div>
            </div>
        );
    },
});

Footer.PropTypes = {
    align: PropTypes.oneOf(['default', 'center']),
};

Footer.defaultProps = {
    align: 'default',
};

export default Footer;
