import React from 'react';
import Url from 'lib/Url';
import { i18n } from 'lib/i18n';
import ConfigStore from 'stores/Config';
import ServiceStore from 'stores/Services';
import RadioGroup from 'lego-ui/RadioGroup';
import { ServiceIcon } from 'components/Icon';

const TYPES = ['connect', 'portal'];

const ICON_SET = {
    connect: [
        'dashboard', 'yamb', 'mail', 'disk', 'staff', 'tracker',
        'forms', 'calendar', 'portal',
    ],
    portal: [
        'mail', 'search', 'calendar', 'disk', 'money', 'images',
        'news', 'maps', 'market',
    ],
};

function getIconSet(type) {
    let iconSet;

    // для отрисовки коннектного меню пробуем достать текущий набор иконок из меню в шапке
    if (type === 'connect') {
        iconSet = [].slice.call(document.querySelectorAll('.app__header .appboard-item'))
            .map(element => ((element.className || '').match(/__(\S+)/) || [])[1])
            .filter(Boolean);
    }

    return (iconSet && iconSet.length ? iconSet : ICON_SET[type]) || [];
}

const HeaderType = React.createClass({

    getInitialState(props) {
        if (!props) {
            props = this.props;
        }

        return {
            val: props.val,
            busy: props.busy,
        };
    },

    componentWillReceiveProps(nextProps) {
        this.setState(this.getInitialState(nextProps));
    },

    _handleChange(val) {
        this.setState({ val });

        if (this.props.onChange) {
            this.props.onChange(val);
        }
    },

    render() {
        const options = TYPES.map(type => ({
            val: type,
            content: <HeaderType.Item val={type} />,
        }));

        return (
            <div className="header-type-switch subsection">
                <RadioGroup
                    name="header"
                    val={this.state.val}
                    busy={this.state.busy}
                    options={options}
                    onChange={this._handleChange}
                />
            </div>
        );
    },

});

HeaderType.Item = React.createClass({

    _renderLogo() {
        return ['yandex', 'mail'].map((key, index) => {
            const url = Url.build(ConfigStore.get('ui.logo'), {
                text: i18n(`related_services.${key}`),
            });

            return <img src={url} className="image" alt={key} key={index} />;
        });
    },

    _renderIcon(id, index) {
        const base = 'header-type__icon';

        return (
            <div className={`${base} ${base}__${id}`} key={index}>
                <ServiceIcon
                    cls={`${base}-image`}
                    serviceSlug={id}
                />
                <div className={`${base}-title`}>
                    {ServiceStore.getName(id) || i18n(`app_menu.${id}`)}
                </div>
            </div>
        );
    },

    render() {
        const base = 'header-type';

        const { val } = this.props;
        const title = i18n(`organization_settings.navigation_header.${val}`);

        return (
            <div className={base}>
                <div className={`${base}__logo`}>
                    {this._renderLogo()}
                </div>
                <div className={`${base}__icon-set`}>
                    <div className={`${base}__icon-set-body`}>
                        {getIconSet(val).map(this._renderIcon)}
                    </div>
                </div>
                <div
                    className={`${base}__label`}
                    dangerouslySetInnerHTML={{ __html: title }}
                />
            </div>
        );
    },

});

export default HeaderType;
