import React from 'react';
import { i18n } from 'lib/i18n';
import Checkbox from 'lego-ui/Checkbox';

const PasswordChangeToggle = React.createClass({

    getInitialState(props) {
        if (!props) {
            props = this.props;
        }

        return {
            checked: Boolean(props.checked),
            busy: props.busy,
        };
    },

    componentWillReceiveProps(nextProps) {
        this.setState(this.getInitialState(nextProps));
    },

    _handleChange(event) {
        const nextValue = event.target.checked;

        if (nextValue === this.state.val) {
            return;
        }

        this.setState({ checked: nextValue });

        setTimeout(() => {
            if (this.props.onChange) {
                this.props.onChange(nextValue);
            }
        }, 0);
    },

    render() {
        const { checked, busy } = this.state;

        return (
            <div className="password-change-setting subsection">
                <Checkbox
                    text={i18n('organization_settings.password_change')}
                    disabled={busy}
                    checked={checked}
                    onChange={this._handleChange}
                />
            </div>
        );
    },

});

export default PasswordChangeToggle;
