import PropTypes from 'prop-types';
import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import Avatar from 'ui-components/lib/Avatar';
import GroupStore from 'stores/Groups';
import ApplicationStore from 'stores/Application';
import Close from './Controls/CloseSubsection';

const CardHeader = React.createClass({

    mixins: [PureRenderMixin],

    render() {
        const { id } = this.props;
        const group = GroupStore.get(id);
        let closeButton;

        if (!group) {
            return null;
        }

        if (ApplicationStore.getPrimaryType() === 'groups') {
            closeButton = <Close />;
        }

        return (
            <div className="group-header section-header card-header">
                {closeButton}
                <div className="section-header__avatar">
                    <Avatar url={group.getAvatar()} size="xxl" />
                </div>
                <h1 className="section-header__title">
                    {group.getName()}
                </h1>
            </div>
        );
    },
});

CardHeader.propTypes = {
    id: PropTypes.string,
};

export default CardHeader;
