import PropTypes from 'prop-types';
import React from 'react';
import ModalActions from 'actions/Modal';
import { i18n } from 'lib/i18n';
import Metrika from 'lib/metrika';

import FlatButton from 'ui/FlatButton';
import Icon from 'ui/Icon';
import AddMembersForm from 'components/Group/Forms/AddMembers';

const METRIKA_MAP = {
    admins: 'Список администраторов',
    members: 'Список пользователей',
};

const AddMembers = React.createClass({

    _handleAddClick() {
        const { id, type } = this.props;
        // type: admins | members

        Metrika.send(
            'Команды', 'Карточка команды', METRIKA_MAP[type],
            'Клик на плюсик', Metrika.getUserType()
        );

        ModalActions.open({
            title: i18n(`group.new_${type}`),
            component: AddMembersForm,
            props: {
                id,
                type,
                onSubmit: this._handleFormDone,
                onCancel: this._handleFormDone,
            },
        });
    },

    _handleFormDone() {
        ModalActions.close();
    },

    render() {
        return (
            <div
                className="add-section-item-control"
                ref="addControl"
            >
                <FlatButton
                    className="plus-button"
                    onClick={this._handleAddClick}
                    width="available"
                    ariaLabel={i18n(`group.action_description.add_${this.props.type}`)}
                >

                    <Icon type="plus-solid-circle" />
                    <FlatButton.Label>{i18n('common.action.add')}</FlatButton.Label>
                </FlatButton>
            </div>
        );
    },
});

AddMembers.propTypes = {
    id: PropTypes.string,
    type: PropTypes.oneOf(['admins', 'members']),
};

export default AddMembers;
