import React from 'react';
import Url from 'lib/Url';
import FlatButton from 'ui/FlatButton';
import Icon from 'ui/Icon';
import { i18n } from 'lib/i18n';

const CloseSubsection = React.createClass({

    _handleCloseClick() {
        // в разделе команд переходим к родительской команде
        Url.open(Url.getParentGroupPath());
    },

    render() {
        return (
            <div className="close-section-control">
                <FlatButton
                    onClick={this._handleCloseClick}
                    ariaLabel={i18n('group.action_description.close_card')}
                >

                    <Icon type="cross" />
                </FlatButton>
            </div>
        );
    },

});

export default CloseSubsection;
