import PropTypes from 'prop-types';
import React from 'react';
import PermissionStore from 'stores/Permissions';
import GroupStore from 'stores/Groups';
import UIActions from 'actions/UI';

import FlatButton from 'ui/FlatButton';
import Icon from 'ui/Icon';
import Metrika from 'lib/metrika';
import { i18n } from 'lib/i18n';

const METRIKA_MAP = {
    admins: 'Список администраторов',
    members: 'Список пользователей',
};

const EditMembers = React.createClass({

    _handleEditClick() {
        Metrika.send(
            'Команды', 'Карточка команды', METRIKA_MAP[this.props.type],
            'Клик на карандаш', Metrika.getUserType()
        );

        UIActions.editGroupMembers(this.props);
    },

    _handleDoneClick() {
        Metrika.send(
            'Команды', 'Карточка команды', METRIKA_MAP[this.props.type],
            'Закрытие редактирования', Metrika.getUserType()
        );

        UIActions.groupMembersEdited(this.props);
    },

    render() {
        const group = GroupStore.get(this.props.id);

        if (!group || !PermissionStore.allowsGroupEditing(group)) {
            return null;
        }

        return (
            <div className="edit-group-members-controls edit-subsection-controls">
                <FlatButton
                    className="edit"
                    onClick={this._handleEditClick}
                    ariaLabel={i18n(`group.action_description.edit_${this.props.type}`)}
                >

                    <Icon type="pen" />
                </FlatButton>
                <FlatButton
                    className="done"
                    onClick={this._handleDoneClick}
                    ariaLabel={i18n('common.action.cancel')}
                >

                    <Icon type="cross" />
                </FlatButton>
            </div>
        );
    },

});

EditMembers.propTypes = {
    id: PropTypes.string,
    type: PropTypes.oneOf([
        'members',
        'admins',
    ]),
};

export default EditMembers;
