import _ from 'lodash';
import PropTypes from 'prop-types';
import React from 'react';
import Menu from 'react-bem-components/lib/Menu';
import UIActions from 'actions/UI';
import ModalActions from 'actions/Modal';
import GroupActions from 'actions/Group';

import GroupStore from 'stores/Groups';
import submit from 'services/submit';
import { i18n } from 'lib/i18n';
import Metrika from 'lib/metrika';

const MENU_OPTIONS = [{
    text: i18n('common.action.edit'),
    val: 'update',
}, {
    text: i18n('common.action.remove'),
    val: 'remove',
}];

const EditMenu = React.createClass({

    _handleMenuSelect(payload) {
        const { id, onSelect } = this.props;

        switch (payload.value) {
            case 'update':
                Metrika.send(
                    'Команды', 'Карточка команды', 'Меню в шапке',
                    'Редактировать', Metrika.getUserType()
                );

                UIActions.editGroup({ id, mode: 'update' });
                break;

            case 'remove':
                Metrika.send(
                    'Команды', 'Карточка команды', 'Меню в шапке',
                    'Удалить', Metrika.getUserType()
                );

                ModalActions.confirm({
                    message: i18n('group.message.confirm_removal', {
                        group: _.escape(GroupStore.getName(id)),
                    }),
                    confirmButtonText: i18n('common.action.remove'),
                    onConfirm() {
                        submit(GroupActions.removeGroup(id), {
                            success: i18n('group.status.removed', {
                                group: GroupStore.getName(id),
                            }),
                            failure: i18n('group.status.failed_to_remove'),
                        });
                    },
                });
                break;
        }

        if (onSelect) {
            onSelect(payload);
        }
    },

    render() {
        return <Menu options={MENU_OPTIONS} onSelect={this._handleMenuSelect} />;
    },
});

EditMenu.propTypes = {
    id: PropTypes.string,
    onSelect: PropTypes.func,
};

export default EditMenu;
