import PropTypes from 'prop-types';
import React from 'react';
import ModalActions from 'actions/Modal';
import UIActions from 'actions/UI';
import { i18n } from 'lib/i18n';
import Metrika from 'lib/metrika';

import FlatButton from 'ui/FlatButton';
import Icon from 'ui/Icon';
import RemoveMembersForm from 'components/Group/Forms/RemoveMembers';

const METRIKA_MAP = {
    admins: 'Список администраторов',
    members: 'Список пользователей',
};

const RemoveMembers = React.createClass({

    _handleClick() {
        const { id, type } = this.props;
        // type: admins | members

        Metrika.send(
            'Команды', 'Карточка команды', METRIKA_MAP[type],
            'Клик на корзину', Metrika.getUserType()
        );

        ModalActions.open({
            title: i18n(`group.message.confirm_${type}_removal`),
            component: RemoveMembersForm,
            props: {
                id,
                type,
                onSubmit: this._handleFormDone,
                onCancel: this._handleFormDone,
            },
        });
    },

    _handleFormDone() {
        UIActions.groupMembersEdited(this.props);
        ModalActions.close();
    },

    render() {
        return (
            <div
                className="add-section-item-control"
                ref="addControl"
            >
                <FlatButton
                    onClick={this._handleClick}
                    width="available"
                    ariaLabel={i18n(`group.action_description.remove_${this.props.type}`)}
                >

                    <Icon type="trash" />
                </FlatButton>
            </div>
        );
    },
});

RemoveMembers.propTypes = {
    id: PropTypes.string,
    type: PropTypes.oneOf(['admins', 'members']),
};

export default RemoveMembers;
