import PropTypes from 'prop-types';
import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import StoreMixin from 'lib/StoreMixin';
import UIStore from 'stores/UI';

import UpdateHeader from 'components/Group/UpdateHeader';
import Header from './Header';

const EditableHeader = React.createClass({

    mixins: [StoreMixin, PureRenderMixin],

    getStoreState() {
        return {
            edit: UIStore.getEditedGroup(this.props.id),
        };
    },

    componentDidMount() {
        this.subscribe(UIStore);
    },

    render() {
        const { id } = this.props;
        const { edit } = this.state;

        const className = [
            'group-header__container',
            edit ? `group-header__container_${edit.mode}` : null,
        ].filter(Boolean).join(' ');

        return (
            <div className={className} key={edit ? edit.mode : null}>
                <Header id={id} />
                <UpdateHeader id={id} />
            </div>
        );
    },

});

EditableHeader.propTypes = {
    id: PropTypes.string,
};

export default EditableHeader;
