import PropTypes from 'prop-types';
import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import StoreMixin from 'lib/StoreMixin';

import GroupStore from 'stores/Groups';
import PermissionStore from 'stores/Permissions';
import UIStore from 'stores/UI';

import AddMembers from './Controls/AddMembers';
import RemoveMembers from './Controls/RemoveMembers';

const Footer = React.createClass({

    mixins: [PureRenderMixin, StoreMixin],

    getStoreState() {
        return { editable: UIStore.isGroupListEditable(this.props) };
    },

    componentDidMount() {
        this.subscribe(UIStore);
    },

    render() {
        const { id, type } = this.props;
        const group = GroupStore.get(id);

        if (!group || !PermissionStore.allowsGroupEditing(group)) {
            return null;
        }

        const EditMembers = this.state.editable ? RemoveMembers : AddMembers;

        return (
            <div className="group-footer section-footer">
                <EditMembers id={id} type={type} />
            </div>
        );
    },

});

Footer.propTypes = {
    id: PropTypes.string,
    type: PropTypes.string,
};

export default Footer;
