import PropTypes from 'prop-types';
import React from 'react';
import { i18n } from 'lib/i18n';
import Form from 'ui/Form';
import Textarea from 'ui/Textarea';

const Description = React.createClass({
    render() {
        const { group, locale, errors } = this.props;

        return (
            <Form.Item
                label={i18n('group.group_description')}
                errors={errors.description}
            >
                <Textarea
                    id="group-form-description"
                    name={`description[${locale}]`}
                    size="m"
                    val={group ? group.getDescription(locale) : ''}
                    width="available"
                />
            </Form.Item>
        );
    },
});

Description.propTypes = {
    group: PropTypes.object,
    locale: PropTypes.string,
    errors: PropTypes.object,
};

Description.defaultProps = {
    locale: 'ru',
    errors: {},
};

export default Description;
