import PropTypes from 'prop-types';
import React from 'react';
import { i18n } from 'lib/i18n';
import Form from 'ui/Form';
import Input from 'ui/Input';
import AuthStore from 'stores/Auth';

const Email = React.createClass({
    render() {
        const { group, clearable, errors } = this.props;

        return (
            <Form.Item
                label={i18n('group.group_email')}
                errors={errors.label}
            >
                <Input
                    id="group-form-label"
                    hasClear={clearable}
                    name="label"
                    size="m"
                    val={group ? group.get('label') : ''}
                    suffix={`@${AuthStore.getOrganizationDomain()}`}
                    width="available"
                />
            </Form.Item>
        );
    },
});

Email.propTypes = {
    group: PropTypes.object,
    clearable: PropTypes.bool,
    errors: PropTypes.object,
};

Email.defaultProps = {
    clearable: true,
    errors: {},
};

export default Email;
