import PropTypes from 'prop-types';
import React from 'react';
import { i18n } from 'lib/i18n';
import Form from 'ui/Form';
import Input from 'ui/Input';

const Name = React.createClass({

    focus() {
        this._getInputRef().focus();
    },

    _setInputRef(input) {
        this._input = input;
    },

    _getInputRef() {
        return this._input;
    },

    render() {
        const { group, clearable, locale, errors } = this.props;

        return (
            <Form.Item
                label={i18n('group.group_name')}
                errors={errors.name}
                required
            >
                <Input
                    id="group-form-name"
                    ref={this._setInputRef}
                    hasClear={clearable}
                    name={`name[${locale}]`}
                    size="m"
                    val={group ? group.getName(locale) : ''}
                    width="available"
                />
            </Form.Item>
        );
    },
});

Name.propTypes = {
    group: PropTypes.object,
    clearable: PropTypes.bool,
    locale: PropTypes.string,
    errors: PropTypes.object,
};

Name.defaultProps = {
    clearable: true,
    locale: 'ru',
    errors: {},
};

export default Name;
