import _ from 'lodash';

function filterInput(data) {
    ['admins', 'members'].forEach(type => {
        if (typeof data[type] === 'string') {
            data[type] = JSON.parse(_.unescape(data[type]));
        }
        if (data[type]) {
            data[type].forEach(item => {
                item.id = Number(item.id);
                item.type = item.type || 'user';
            });
        }
    });

    return data;
}

export default filterInput;
