import PropTypes from 'prop-types';
import { i18n } from 'lib/i18n';
import EditMembers from './Controls/EditMembers';

const Subheader = props => (
    <div className="group-subheader section-subheader">
        <h2 className="section-subheader__title">
            {i18n(`group.${props.type}`)}
        </h2>
        <EditMembers id={props.id} type={props.type} />
    </div>
);

Subheader.propTypes = {
    id: PropTypes.string,
    type: PropTypes.string,
};

export default Subheader;
