import PropTypes from 'prop-types';
import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import classSet from 'classnames';
import StoreMixin from 'lib/StoreMixin';
import UIStore from 'stores/UI';

import Subheader from './Subheader';
import Body from './Body';
import Footer from './Footer';

const Subsection = React.createClass({

    mixins: [PureRenderMixin, StoreMixin],

    getStoreState() {
        return { editable: UIStore.isGroupListEditable(this.props) };
    },

    componentDidMount() {
        this.subscribe(UIStore);
    },

    render() {
        const { id, type } = this.props;
        const className = classSet({
            'section-column': true,
            'section-column_editable': this.state.editable,
        });

        return (
            <div className={className}>
                <Subheader id={id} type={type} />
                <Body id={id} type={type} />
                <Footer id={id} type={type} />
            </div>
        );
    },

});

Subsection.propTypes = {
    id: PropTypes.string,
    type: PropTypes.string,
};

export default Subsection;
