import PropTypes from 'prop-types';
import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import UIActions from 'actions/UI';
import UpdateForm from 'components/Group/Forms/Update';

const UpdateHeader = React.createClass({

    mixins: [PureRenderMixin],

    _handleEditDone() {
        UIActions.groupEdited(this.props.id);
    },

    render() {
        const { id } = this.props;

        return (
            <div className="group-header group-header_update section-header unpadded">
                <UpdateForm id={id} onSubmit={this._handleEditDone} />
                <div className="section-header__close" onClick={this._handleEditDone} />
            </div>
        );
    },

});

UpdateHeader.propTypes = {
    id: PropTypes.string,
};

export default UpdateHeader;
