import PropTypes from 'prop-types';
import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import StoreMixin from 'lib/StoreMixin';
import GroupStore from 'stores/Groups';
import PermissionStore from 'stores/Permissions';

import timer from 'lib/timer';
import EditableHeader from './EditableHeader';
import CardHeader from './CardHeader';
import Subsection from './Subsection';
import Body from './Body';

import './index.css';

const Group = React.createClass({

    mixins: [PureRenderMixin, StoreMixin],

    getStoreState() {
        return { key: this.hashCode() };
    },

    componentDidMount() {
        this.subscribe([GroupStore, PermissionStore]);

        timer.stop('create_group');
    },

    render() {
        const { id, flat } = this.props;

        if (!GroupStore.get(id)) {
            return null;
        }

        if (flat) {
            return (
                <div className="group-section column-section section" key={this.state.key}>
                    <CardHeader id={id} />
                    <Body id={id} flat />
                </div>
            );
        }

        return (
            <div className="group-section fixed-width card-section section" key={this.state.key}>
                <EditableHeader id={id} />
                <div className="section-columns">
                    <Subsection id={id} type="admins" />
                    <Subsection id={id} type="members" />
                </div>
            </div>
        );
    },

});

Group.propTypes = {
    id: PropTypes.string,
    flat: PropTypes.bool,
};

export default Group;
