import React from 'react';
import GroupModalActions from 'actions/Modal.Group';
import Url from 'lib/Url';
import Metrika from 'lib/metrika';
import { i18n } from 'lib/i18n';

import FlatButton from 'ui/FlatButton';
import Icon from 'ui/Icon';

const Add = React.createClass({

    componentDidMount() {
        if (Url.getInitialAction() === Url.Actions.ADD_GROUP) {
            setTimeout(() => {
                Url.replace(location.pathname);
                GroupModalActions.create();
            }, 0);
        }
    },

    _handleAddClick() {
        Metrika.send('Команды', 'Список команд', 'Клик в плюсик');
        GroupModalActions.create();
    },

    render() {
        return (
            <div
                className="add-section-item-control"
                ref="addControl"
            >
                <FlatButton
                    className="plus-button"
                    onClick={this._handleAddClick}
                    width="available"
                    ariaLabel={i18n('group.action_description.add')}
                >
                    <Icon type="plus-solid-circle" />
                    <FlatButton.Label>{i18n('common.action.add')}</FlatButton.Label>
                </FlatButton>
            </div>
        );
    },

});

Add.propTypes = {

};

export default Add;
