import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import StoreMixin from 'lib/StoreMixin';
import ApplicationStore from 'stores/Application';

import List from './List';
import Footer from './Footer';

import './index.css';

const GroupList = React.createClass({

    mixins: [StoreMixin, PureRenderMixin],

    getStoreState() {
        return { stateId: ApplicationStore.getStateId() };
    },

    componentDidMount() {
        this.subscribe(ApplicationStore);
        this._scrollToSelected();
    },

    componentDidUpdate(prevProps, prevState) {
        if (this.state.stateId !== prevState.stateId) {
            this._scrollToSelected();
        }
    },

    _getSelectedItem() {
        const list = this.refs.list;

        return list ? list.refs.selectedGroup : null;
    },

    _scrollToSelected() {
        setTimeout(() => {
            this.setState({ scrollTo: this._getSelectedItem() || 0 });
        }, 0);
    },

    render() {
        return (
            <div className="group-list-section section">
                <div className="group-list-body section-body">
                    <List ref="list" scrollTo={this.state.scrollTo} />
                </div>
                <Footer />
            </div>
        );
    },

});

GroupList.propTypes = {

};

export default GroupList;
