import React from 'react';
import * as packageMeta from '@yandex-lego/serp-header/static.meta.js';
import * as User from '@yandex-lego/serp-header/dist/organizations/user2.desktop';
import { getCookie } from '@connect/cookies-lite';
import buildUrl from '@connect/url-placeholders';
import ConfigStore from 'stores/Config';
import AuthStore from 'stores/Auth';
import getOrgChangeUrl from 'lib2/getOrgChangeUrl';
import getNonce from 'lib2/getNonce';
import { getUser2Options } from './options';

import './legouser.css';

const NONCE = getNonce();

const HeaderUser = React.createClass({
    componentDidMount() {
        if (!document.querySelector('script.user2')) {
            document.head.appendChild(
                Object.assign(document.createElement('script'), {
                    src: `${packageMeta.BASE_PATH}organizations/user2/user2-base.desktop.client.js`,
                    className: 'user2',
                })
            );
        }
    },

    render() {
        let user = AuthStore.getUser();
        let { tld, locale, isProd } = ConfigStore.get('app').toJS();

        if (!user.getId()) {
            return null;
        }

        let retpath = new URL(window.location.href).searchParams.get('retpath') ||
            new URL('/portal/home', window.location.origin).href;

        return (
            <div
                className="user2-widget"
                dangerouslySetInnerHTML={{
                    __html: User.getContent({
                        tld,
                        lang: locale,
                        nonce: NONCE,
                        ctx: {
                            organizationsUrl: buildUrl(ConfigStore.get('org.list'), { tld }),
                            contextSwitchUrl: getOrgChangeUrl(null, retpath),
                            addOrganizationUrl: buildUrl(ConfigStore.get('org.add'), {
                                retpath,
                                source: 'connect',
                                preset: '',
                            }),
                            passportHost: buildUrl(ConfigStore.get('passport.host'), { tld }),
                            accountsUrl: buildUrl(ConfigStore.get('passport.accounts'), { tld }),
                            avatarHost: ConfigStore.get('ui.avatar.host'),
                            helpUrl: ConfigStore.getHelpUrl('ui.help.main', { tld }),
                            customMenuItems: getUser2Options(),
                            noCounter: !isProd,
                            hasPlus: isProd,
                            yaplusAvailable: isProd,
                            retpath,
                            uid: user && user.getId(),
                            avatarId: user && user.get('avatar_id'),
                            yu: getCookie('yandexuid'),
                            name: user && (user.get('display_name') || user.get('nickname') || user.get('login')),
                            source: 'connect',
                            secretKey: window.ya.connect.initial.sk,
                        },
                    }),
                }}
            />
        );
    },
});

export default HeaderUser;
