import { Permissions } from 'constants/Common';
import { i18n } from 'lib/i18n';
import AuthStore from 'stores/Auth';
import ConfigStore from 'stores/Config';
import SubscriptionStore from 'stores/Subscription';
import PermissionStore from 'stores/Permissions';
import Url from 'lib/Url';
import plusIcon from '../../../static/i/plus-light-circle.svg';

const { session } = window.ya.connect.initial;

export const MenuOptions = {
    mail: {
        text: i18n('related_services.mail'),
        metrika: 'Почта',
        val: 'mail',
    },
    disk: {
        text: i18n('related_services.disk'),
        metrika: 'Диск',
        val: 'disk',
    },
    passport: {
        text: i18n('related_services.passport'),
        metrika: 'Паспорт',
        val: 'passport',
    },
    about_me: {
        _url: session && Url.getUserPath(session.id),
        text: i18n('common_options.about_me'),
        metrika: 'Обо мне',
        val: 'about_me',
        available: () => Boolean(session && AuthStore.isInternal()),
    },
    leave_org: {
        text: i18n('common_options.leave_organization'),
        metrika: 'Покинуть организацию',
        val: 'leave_organization',
        _url: '/portal/home#leave-organization',
        available: () => PermissionStore.contains(Permissions.LEAVE_ORGANIZATION),
    },
    help: {
        text: i18n('common_options.help'),
        metrika: 'Помощь',
        val: 'help',
    },
    offer: {
        _url: ConfigStore.get('ui.help.offer'),
        text: i18n('common_options.offer'),
        metrika: 'Оферта',
        val: 'offer',
        available: () => PermissionStore.contains(Permissions.PAY) && (
            SubscriptionStore.getPlan() !== 'free' ||
                AuthStore.hasPaidServices() ||
                AuthStore.hasDebt()
        ),
    },
    logout: {
        text: i18n('common_options.logout'),
        metrika: 'Выход',
        val: 'logout',
    },
    new_session: {
        text: i18n('common_options.add_user'),
        metrika: 'Добавить пользователя',
        val: 'add_session',
        icon: plusIcon,
    },
};

export const MENU_OPTIONS = [{
    group: [
        MenuOptions.mail,
        MenuOptions.disk,
        MenuOptions.passport,
    ],
}, {
    group: [
        MenuOptions.about_me,
        MenuOptions.leave_org,
        MenuOptions.help,
        MenuOptions.offer,
        MenuOptions.logout,
    ],
}];

export function getUser2Options() {
    return ['about_me', 'offer', 'leave_org']
        .map(key => {
            let { _url, text, available } = MenuOptions[key];

            if (typeof available === 'function' ? available() : available !== false) {
                return {
                    text,
                    url: _url,
                    action: `custom_${key}`,
                };
            }
        })
        .filter(Boolean);
}
