import PropTypes from 'prop-types';
import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import classSet from 'classnames';
import Button from 'react-bem-components/lib/Button';
import { i18n } from 'lib/i18n';
import Metrika from 'lib/metrika';
import ModalActions from 'actions/Modal';

import Slider from 'ui/Slider';
import FlatButton from 'ui/FlatButton';
import Icon from 'ui/Icon';

import './index.css';

const Intro = React.createClass({

    mixins: [PureRenderMixin],

    getInitialState() {
        return {
            index: 0,
            size: this.props.items.length,
        };
    },

    componentDidMount() {
        Metrika.send('Онбординг', 'Показ', '1 слайд');

        this._keyboardHandler = event => {
            if (event.defaultPrevented) {
                return;
            }

            switch (event.key) {
                case 'ArrowRight':
                case ' ':
                    this._next();
                    break;
                case 'ArrowLeft':
                    this._previous();
                    break;
                case 'Escape':
                    this._close();
                    break;
            }
        };

        window.addEventListener('keypress', this._keyboardHandler);
    },

    componentWillUnmount() {
        if (this._keyboardHandler) {
            window.removeEventListener('keypress', this._keyboardHandler);
        }
    },

    _setIndex(index) {
        if (index >= 0 && index < this.state.size) {
            Metrika.send('Онбординг', 'Показ', `${index + 1} слайд`);
            this.setState({ index });
        } else {
            this._close();
        }
    },

    _close() {
        Metrika.send('Онбординг', 'Закрытие');
        ModalActions.close();
    },

    _next() {
        Metrika.send('Онбординг', 'Следущий');
        this._setIndex(this.state.index + 1);
    },

    _previous() {
        Metrika.send('Онбординг', 'Предыдущий');
        this._setIndex(this.state.index - 1);
    },

    _handleNavigationChange(item) {
        Metrika.send('Онбординг', 'Клик в навигацию');
        this._setIndex(item.index);
    },

    _renderItems() {
        return this.props.items.map((item, index) => (
            <Slider.Item mod={String(item.id || index + 1)} key={index}>
                <div className="slide-header" />
                <div
                    className="slide-body"
                    dangerouslySetInnerHTML={{ __html: item.content }}
                />
            </Slider.Item>
        ));
    },

    render() {
        const { items, mod } = this.props;
        const { index, size } = this.state;

        const nextActionText = (items[index] || {}).nextActionText ||
            i18n(`intro.action.${index === size - 1 ? 'done' : 'next'}`);

        const className = classSet({
            'intro-dialog': true,
            [`intro-dialog__${mod}`]: mod !== undefined,
        });

        return (
            <div className={className}>
                <Slider index={index}>{this._renderItems()}</Slider>
                <div className="slider-action">
                    <Button text={nextActionText} view="action" onClick={this._next} />
                </div>
                <Slider.Navigation
                    size={size}
                    index={index}
                    onChange={this._handleNavigationChange}
                />
                <FlatButton className="intro-dialog__close" onClick={this._close}>
                    <Icon type="light-cross" />
                </FlatButton>
            </div>
        );
    },

});

Intro.propTypes = {
    items: PropTypes.array,
    mod: PropTypes.string,
};

Intro.defaultProps = {
    items: [],
};

export default Intro;
