import PropTypes from 'prop-types';
import React from 'react';
import { block } from 'bem-cn';
import Icon from 'ui/Icon';

import './input-item.css';

const bInputItem = block('input-item');

const InputItem = props => {
    const { content, onRemove } = props;

    return (
        <div className={bInputItem()}>
            <div className={bInputItem('text')}>
                {content}
            </div>
            <div
                className={bInputItem('close-btn')}
                onClick={onRemove}
            >

                <Icon type="cross" />
            </div>
        </div>
    );
};

InputItem.propTypes = {
    content: PropTypes.string.isRequired,
    onRemove: PropTypes.func.isRequired,
};

export default InputItem;
