import Invite from 'components/Invite';
import Footer from 'components/Footer';

import { i18n } from 'lib/i18n';
import Url from 'lib/Url';

import './index.css';

import ConfigStore from 'stores/Config';

export default () => (
    <div className="invite-page">
        <div className="invite-page__content">
            <div className="invite-page__header">
                <a href={ConfigStore.get('ui.rootPage')}>
                    <img
                        className="invite-page__img_title"
                        src={ConfigStore.get('ui.logo', { text: i18n('common.yandex') })}
                        alt={i18n('common.yandex')}
                    />
                </a>

                <a href="/?noredirect=1">
                    <img
                        className="invite-page__img_service"
                        src={ConfigStore.get('ui.logo', { text: i18n('common.connect') })}
                        alt={i18n('common.connect')}
                    />
                </a>
            </div>
            <Invite id={Url.getQueryParam('code')} />
        </div>
        <Footer align="center" />
    </div>
);
