import PropTypes from 'prop-types';
import React from 'react';
import { Button } from 'lego-on-react';
import ModalActions from 'actions/Modal';
import { i18n } from 'lib/i18n';
import Form from 'ui/Form';

import './index.css';

const Alert = React.createClass({

    componentDidMount() {
        const { confirmButton } = this.refs;

        if (confirmButton) {
            confirmButton.control.focus();
        }
    },

    _handleConfirm() {
        const { onClose } = this.props;

        ModalActions.close();

        if (onClose) {
            onClose();
        }
    },

    render() {
        const { confirmButtonText } = this.props;

        return (
            <Form
                className="alert-dialog-form dialog-form form"
                ref="form"
                onSubmit={this._handleConfirm}
                autoComplete={false}
            >

                <div
                    className="dialog-form__message"
                    dangerouslySetInnerHTML={{ __html: this.props.message }}
                />

                <Form.Buttons>
                    <Button text={confirmButtonText} ref="confirmButton" size="m" theme="action" type="submit" />
                </Form.Buttons>
            </Form>
        );
    },

});

Alert.propTypes = {
    message: PropTypes.string,
    confirmButtonText: PropTypes.string,
};

Alert.defaultProps = {
    confirmButtonText: i18n('common.action.ok'),
};

export default Alert;
