import React from 'react';

import { Link } from 'lego-on-react';
import Metrika from 'lib/metrika';
import Url from 'lib/Url';

export default class NavLink extends React.Component {
    constructor(props) {
        super(props);
        this._handleClick = this._handleClick.bind(this);
    }

    _handleClick(event) {
        const { onClick, target, url, metrika, hard } = this.props;

        if (onClick) {
            onClick(event);
        }

        if (metrika) {
            Metrika.send(metrika);
        }

        if (!event.ctrlKey && !event.shiftKey && !event.altKey && !event.metaKey && !hard) {
            event.preventDefault();
            if (url) {
                Url.open(url, target);
            }
        }
    }

    render() {
        return (
            <Link
                {...this.props}
                onClick={this._handleClick}
            />
        );
    }
}
