import ApplicationStore from 'stores/Application';
import AuthStore from 'stores/Auth';
import Url from 'lib/Url';
import { i18n } from 'lib/i18n';

function matchesStateTypes(types) {
    return types.indexOf(ApplicationStore.getStateType()) !== -1;
}

function matchesCurrentUser() {
    return Url.getCurrentPath() === Url.getUserPath(AuthStore.getUserId());
}

const MENU_SECTIONS = [
    {
        text: i18n('sections.organization_structure'),
        metrika: 'Оргструктура',
        url: () => Url.getContextPath('structure'),
        matches: () => matchesStateTypes(['', 'users', 'departments']) && !matchesCurrentUser(),
    },
    {
        text: i18n('sections.groups._title'),
        metrika: 'Команды',
        matches: () => matchesStateTypes([
            'groups',
            'groups/admins/users',
            'groups/admins/departments',
            'groups/admins/groups',
            'groups/members/users',
            'groups/members/departments',
            'groups/members/groups',

            'groups/admin',
            'groups/admin/admins/users',
            'groups/admin/admins/departments',
            'groups/admin/admins/groups',
            'groups/admin/members/users',
            'groups/admin/members/departments',
            'groups/admin/members/groups',

            'groups/member',
            'groups/member/admins/users',
            'groups/member/admins/departments',
            'groups/member/admins/groups',
            'groups/member/members/users',
            'groups/member/members/departments',
            'groups/member/members/groups',
        ]),
        subsections: [
            {
                text: i18n('sections.groups.all'),
                metrika: 'Все команды',
                url: () => Url.getGroupListPath('all'),
            },
            {
                text: i18n('sections.groups.admin'),
                metrika: 'Я администратор',
                url: () => Url.getGroupListPath('admin'),
                available: () => AuthStore.isInternal(),
            },
            {
                text: i18n('sections.groups.member'),
                metrika: 'Я участник',
                url: () => Url.getGroupListPath('member'),
                available: () => AuthStore.isInternal(),
            },
        ],
    },
    {
        text: i18n('common_options.about_me'),
        metrika: 'Обо мне',
        url: () => AuthStore.getUser().getUrl(),
        available: () => AuthStore.isInternal(),
        matches: () => matchesCurrentUser(),
    },
];

export default MENU_SECTIONS;
