import PropTypes from 'prop-types';
import React from 'react';

import { Button } from 'lego-on-react';
import { block } from 'bem-cn';
import { i18n } from 'lib/i18n';

import InviteForm from 'components/InviteForm';
import ProgressPager from './ProgressPager';

const bOnboarding = block('onboarding');
const bOnboardingInvite = block('onboarding-invite');

const Invite = ({ next, step }) => (
    <div className={bOnboardingInvite}>
        <div className={bOnboarding('progress')}>
            <ProgressPager page={step} count={3} />
        </div>
        <div className={bOnboardingInvite('content')}>
            <div className={bOnboardingInvite('icon')} />
            <h1 className={bOnboarding('header')}>
                {i18n('onboarding.yo.invite.header')}
            </h1>
            <h2 className={bOnboarding('description')}>
                {i18n('onboarding.yo.invite.description')}
            </h2>
            <div className={bOnboardingInvite('form')}>
                <InviteForm
                    buttonText={i18n('onboarding.yo.invite.button.invite')}
                    buttonWidth="max"
                    departmentId={1}
                    onSubmit={next}
                />
                <Button
                    theme="clear"
                    view="default"
                    tone="default"
                    size="m"
                    width="max"
                    cls={bOnboardingInvite('button')}
                    onClick={next}
                >
                    {i18n('onboarding.yo.invite.button.next')}
                </Button>
            </div>
        </div>
    </div>
);

Invite.propTypes = {
    next: PropTypes.func.isRequired,
};

export default Invite;
