import PropTypes from 'prop-types';

import './progress-pager.css';
import { block } from 'bem-cn';

const bOnboardingProgress = block('onboarding-progress');

const ProgressPager = ({ page, count }) => {
    const pages = [];

    for (let i = 0; i < count; i += 1) {
        pages.push(
            <div className={bOnboardingProgress('page', { active: i < page ? 'yes' : 'no' })} key={`page-${i}`} />
        );
    }

    return (
        <div className={bOnboardingProgress()}>
            {pages}
        </div>
    );
};

ProgressPager.propTypes = {
    count: PropTypes.number.isRequired,
    page: PropTypes.number.isRequired,
};

export default ProgressPager;
