import PropTypes from 'prop-types';
import React from 'react';
import { block } from 'bem-cn';
import { Button } from 'lego-on-react';

import { i18n } from 'lib/i18n';

import OnboardingService from 'components/OnboardingService';
import ProgressPager from './ProgressPager';

const bOnboarding = block('onboarding');
const bOnboardingServices = block('onboarding-services');
const services = [
    'tracker',
    'mail',
];
const servicesContent = services.map(service => (
    <OnboardingService
        name={service}
        key={`service_${service}`}
    />
));

const Services = ({ next, step }) => (
    <div className={bOnboardingServices}>
        <div className={bOnboarding('progress')}>
            <ProgressPager page={step} count={3} />
        </div>
        <h1 className={bOnboarding('header')}>
            {i18n('onboarding.yo.services.header')}
        </h1>
        <h2 className={bOnboarding('description')}>
            {i18n('onboarding.yo.services.description')}
        </h2>
        <div className={bOnboarding('services')}>
            {servicesContent}
        </div>
        <Button
            theme="action"
            view="default"
            tone="default"
            size="m"
            cls={bOnboardingServices('button')}
            onClick={next}
        >
            {i18n('onboarding.yo.services.button')}
        </Button>
    </div>
);

Services.propTypes = {
    next: PropTypes.func.isRequired,
    step: PropTypes.number,
};

export default Services;
