import PropTypes from 'prop-types';
import { block } from 'bem-cn';
import { Button } from 'lego-on-react';
import Process from 'ui/Process';
import Form from 'ui/Form';

import OnboardingService from 'components/OnboardingService';

import { i18n } from 'lib/i18n';
import ProgressPager from './ProgressPager';

const bOnboarding = block('onboarding');
const bSubscribeNews = block('onboarding-subscribe');

const SubscribeNews = ({ buttonLoading, globalLoading, error, step, services, onSubscribe, onSkip }) => (
    <div className={bSubscribeNews}>
        <div className={bOnboarding('progress')}>
            <ProgressPager page={step} count={3} />
        </div>
        <h1 className={bOnboarding('header')}>
            {i18n('onboarding.yo.subscribe.header')}
        </h1>
        <h2 className={bOnboarding('description')}>
            {i18n('onboarding.yo.subscribe.description')}
        </h2>
        <div className={bOnboarding('services')}>
            {services.map(service => <OnboardingService name={service} key={`service_${service}`} />)}
        </div>
        <Button
            theme="action"
            view="default"
            tone="default"
            size="m"
            cls={bSubscribeNews('button')}
            progress={buttonLoading}
            onClick={onSubscribe}
        >

            {i18n('onboarding.yo.subscribe.button')}
        </Button>
        <Form.Error value={error} mod="standalone" />
        <Button
            theme="clear"
            view="default"
            tone="default"
            size="m"
            cls={bSubscribeNews('skip')}
            onClick={onSkip}
        >
            {i18n('onboarding.yo.subscribe.skip')}
        </Button>
        <Process running={globalLoading} size="xl" />
    </div>
);

SubscribeNews.propTypes = {
    onSubscribe: PropTypes.func.isRequired,
    onSkip: PropTypes.func.isRequired,
    services: PropTypes.array,
    step: PropTypes.number,
    buttonLoading: PropTypes.bool,
    globalLoading: PropTypes.bool,
    error: PropTypes.any,
};

export default SubscribeNews;
