import PropTypes from 'prop-types';
import React from 'react';
import { block } from 'bem-cn';
import { Button } from 'lego-on-react';

import { i18n } from 'lib/i18n';

const bOnboarding = block('onboarding');
const bWelcome = block('onboarding-welcome');

const Welcome = ({ next }) => (
    <div className={bWelcome}>
        <div className={bWelcome('pic')} />
        <h1 className={bOnboarding('header')}>
            {i18n('onboarding.yo.welcome.header')}
        </h1>
        <h2 className={bOnboarding('description')}>
            {i18n('onboarding.yo.welcome.description')}
        </h2>
        <Button
            theme="action"
            view="default"
            tone="default"
            size="m"
            onClick={next}
        >
            {i18n('onboarding.yo.welcome.button')}
        </Button>
    </div>
);

Welcome.propTypes = {
    next: PropTypes.func,
};

export default Welcome;
