import PropTypes from 'prop-types';
import React from 'react';
import { block } from 'bem-cn';
import Url from 'lib/Url';

import Welcome from './components/Welcome';
import SubscribeNewsBox from './components/SubscribeNewsBox';
import Invite from './components/Invite';
import Services from './components/Services';

import './index.css';

const defaultStep = 0;
const bOnboarding = block('onboarding');

const componentsList = [
    Welcome,
    SubscribeNewsBox,
    Invite,
    Services,
];

const Onboarding = React.createClass({

    getInitialState() {
        let { step } = this.props;

        if (step < 0 || step > 3) {
            step = defaultStep;
        }

        return {
            step,
        };
    },

    _next() {
        let { step } = this.state;

        step += 1;

        if (!componentsList[step]) {
            Url.open(Url.getDashboardUrl());

            return;
        }

        this.setState({ step });
    },

    render() {
        const { step } = this.state;
        const CurrentComponent = componentsList[step];

        return (
            <div className={bOnboarding}>
                <CurrentComponent next={this._next} step={step} />
            </div>
        );
    },
});

Onboarding.propTypes = {
    step: PropTypes.number,
};

Onboarding.defaultProps = {
    step: defaultStep,
};

export default Onboarding;
