import { block } from 'bem-cn';
import Header from 'components/Header';
import Footer from 'components/Footer';
import Onboarding from 'components/Onboarding';

import Url from 'lib/Url';

import './index.css';

const bOnboardingLayout = block('onboarding-layout');
const step = Number(Url.getQueryParam('step'));

export default () => (
    <div className={bOnboardingLayout}>
        <Header searchEnabled={false} orgSwitchEnabled={false} />
        <div className={bOnboardingLayout('body')}>
            <Onboarding step={Number.isNaN(step) ? 0 : step} />
        </div>
        <Footer align="center" />
    </div>
);
