import PropTypes from 'prop-types';
import Icon from 'ui/Icon';
import { i18n } from 'lib/i18n';

import './index.css';

const OnboardingService = ({ name }) => (
    <div className="service-list-item">
        <div className="service-list-item__icon">
            <Icon
                type={name}
                title={i18n(`onboarding.service.name.${name}`)}
                size="xxxl"
            />
        </div>
        <span className="service-list-item__title">
            {i18n(`onboarding.service.name.${name}`)}
        </span>
        <span className="service-list-item__description">
            {i18n(`onboarding.service.description.${name}`)}
        </span>
    </div>
);

OnboardingService.propTypes = {
    name: PropTypes.string.isRequired,
};

export default OnboardingService;
